import argparse

from configUtils import *

##################Global Variables########################
WEBRTC_DAT_FILE = "webrtcConfig.dat"
NETWORK_MANAGEMENT = "API Network Management"
CERTIFICATES = "API Certificates"
NETWORK_MANAGEMENT_STATUS = "API Network Status"
TLS_CLIENT_PROFILES = "API TLS Client Profiles"
TLS_SERVER_PROFILES = "API TLS Server Profiles"
REVERSE_PROXY_PROFILE = "API Reverse Proxy Profile"
REVERSE_PROXY_RELAY = "API Reverse Proxy Relays"
TURN_STUN_PROFILE = "API Turn Stun Profile"
TURN_STUN_RELAY = "API Turn Stun Relay"
LOAD_MONITORING_PROFILE = "API Load Monitoring"


def network_management():
    try:
        config_data = APIUtilities.file_utils(NETWORK_MANAGEMENT)
        return APIUtilities.return_result(config_data, APIDefs.NETWORK_MANAGEMENT.value, "networkId")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e


def network_management_status():
    config_data = APIUtilities.file_utils(NETWORK_MANAGEMENT_STATUS)
    config_data = map(lambda a: a.strip(":"), (config_data[0].split()))
    data_dict = APIUtilities.list_to_dict(config_data)
    for k, v in data_dict.items():
        api_path = "/api/config/v1/network-management/interfaces/%s:%s" % (k, v)
        # print("key is %s" %(k,v))
        APIUtilities.send_request(api_path, "interfaceName", data_dict, True)


def certificates():
    try:
        config_data = APIUtilities.file_utils(CERTIFICATES)
        return APIUtilities.return_result(config_data, APIDefs.CERTIFICATES.value, "")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e


def tls_client_profiles():
    try:
        default_data = {"peerCrlList": [], "verificationDepth": 1, "renegotiationTimeInSeconds": 30,
                        "renegotationByteCount": 0}
        config_data = APIUtilities.file_utils(TLS_CLIENT_PROFILES)
        return APIUtilities.return_result(config_data, APIDefs.TLS_CLIENT_PROFILES.value, "id", default_data)
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e


def tls_server_profiles():
    try:
        config_data = APIUtilities.file_utils(TLS_SERVER_PROFILES)
        return APIUtilities.return_result(config_data, APIDefs.TLS_SERVER_PROFILES.value, "id")

    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e


def reverse_proxy_profile():
    print("In reverse proxy profile...")
    default_data = {"clientMaxBodySizeInMB": 10, "clientBodyTimeoutInSeconds": 30, "clientHeaderTimeoutInSeconds": 30,
                    "dnsResolverTimeoutInSeconds": 30, "sslSessionTimeoutInSeconds": 300,
                    "serverReadTimeoutInSeconds": 300}
    config_data = APIUtilities.file_utils(REVERSE_PROXY_PROFILE)
    print("config data: ")
    print(config_data)
    return APIUtilities.return_result(config_data, APIDefs.REVERSE_PROXY_PROFILES.value, "profileId", default_data)


def reverse_proxy_relays():
    try:
        print("In reverse proxy relay...")
        config_data = APIUtilities.file_utils(REVERSE_PROXY_RELAY)
        return APIUtilities.return_result(config_data, APIDefs.REVERSE_PROXY_RELAYS.value, "id")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e


def turn_stun_profile():
    try:
        default_data = {"fingerPrint": "true", "tcpRelay": "true", "udpRelay": "false", "dtls": "false",
                        "mediaLearning": "true", "alternateServer1": "", "alternateServer2": "", "alternateServer3": ""}
        config_data = APIUtilities.file_utils(TURN_STUN_PROFILE)
        return APIUtilities.return_result(config_data, APIDefs.TURN_STUN_PROFILES.value, "profileId", default_data)
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e
        

def turn_stun_relay():
    config_data = APIUtilities.file_utils(TURN_STUN_RELAY)
    return APIUtilities.return_result(config_data, APIDefs.TURN_STUN_RELAYS.value, "turnStunProfileId")


def load_monitoring():
    default_data = {"serviceType": "TURN", "loadBalancerType": "INTERNAL"}
    print(default_data)
    config_data = APIUtilities.file_utils(LOAD_MONITORING_PROFILE)
    print(config_data)
    return APIUtilities.return_result(config_data, APIDefs.LOAD_MONITORING_PROFILES.value, "profileId", default_data)


def post_all():
    print("entered POST all")
    APIUtilities.getToken(APIDefs.API_TOKEN.value)
    APIUtilities.check_id(network_management(), "NETWORK_MANAGEMENT")
    APIUtilities.create_map(APIDefs.NETWORK_MANAGEMENT.value, APIUtilities.get_request(APIDefs.NETWORK_MANAGEMENT.value))
    network_management_status()

    APIUtilities.check_id(certificates(), "CERTIFICATES")
    APIUtilities.check_id(tls_client_profiles(), "TLS_CLIENT_PROFILES")
    APIUtilities.create_map(APIDefs.TLS_CLIENT_PROFILES.value,
                            APIUtilities.get_request(APIDefs.TLS_CLIENT_PROFILES.value))
    APIUtilities.check_id(tls_server_profiles(), "TLS_SERVER_PROFILES")
    APIUtilities.create_map(APIDefs.TLS_SERVER_PROFILES.value,
                            APIUtilities.get_request(APIDefs.TLS_SERVER_PROFILES.value))
    APIUtilities.check_id(reverse_proxy_profile(), "REVERSE_PROXY_PROFILES")
    APIUtilities.create_map(APIDefs.REVERSE_PROXY_PROFILES.value, APIUtilities.get_request(APIDefs.REVERSE_PROXY_PROFILES.value))
    APIUtilities.check_id(reverse_proxy_relays(), "REVERSE_PROXY_RELAYS")
    APIUtilities.check_id(turn_stun_profile(), "TURN_STUN_PROFILES")
    APIUtilities.create_map(APIDefs.TURN_STUN_PROFILES.value, APIUtilities.get_request(APIDefs.TURN_STUN_PROFILES.value))
    APIUtilities.check_id(turn_stun_relay(), "TURN_STUN_RELAYS")
    APIUtilities.check_id(load_monitoring(), "LOAD_MONITORING_PROFILES")

    print("API add completed")


def delete_resource(apiname, id):
    APIUtilities.getToken(APIDefs.API_TOKEN.value)
    APIUtilities.delete_request(apiname, id)


if __name__ == '__main__':
    try:
        obj = APIUtilities(WEBRTC_DAT_FILE)
        parser = argparse.ArgumentParser()

        parser.add_argument("HTTPMETHOD", choices={"POST", "DELETE"}, type=str)
        parser.add_argument("--apiname", type=str, choices=list(APIDefs.__members__),
                            help="Delete a configuration for HTTP call flow for given API, only used with DELETE")
        parser.add_argument("--id", type=int, help="The ID to be deleted, required only for DELETE")
        parser.add_argument("--certificate_type", type=str, help="Available values : cert, ca, crl, key, csr")
        parser.add_argument("--certificate_name", type=str, help="Name of the certificate installed")

        args = (parser.parse_args())

        if args.HTTPMETHOD == "POST":
            post_all()
        if args.HTTPMETHOD == "DELETE":
            if args.apiname == "CERTIFICATES":
                if args.certificate_type is None or args.certificate_name is None:
                    print("--certificate_type and --certificate_name required for DELETE of certificates")
                    sys.exit(0)
                else:
                    args.id = {args.certificate_type: args.certificate_name}
            if args.apiname is None or args.id is None:
                print("--apiname and --id required for DELETE")
                sys.exit(0)
            delete_resource(args.apiname, args.id)

    except Exception as e:
        print("Error in main %s" % e)
        APIUtilities.bulk_delete()
